//
//  MCConfigDOServerProtocol.h
//  MCClientServer
//
//  Created by Michael Clark on 09-09-17.
//  Copyright 2009 Marketcircle, Inc. All rights reserved.
//


// Protocol for the Distributed Objects implementation of this proxy.

@protocol MCConfigDOServerProtocol <NSObject>

- (BOOL)pingTest; // Connection testing

- (void)closeConnection;

#pragma mark Postgres
- (BOOL)isPostgresRunning;
- (BOOL)startPostgresWithOptions:(NSArray*)options error:(NSError **)error;
- (BOOL)startPostgresAndReturnError: (NSError **)error;
- (BOOL)stopPostgresAndReturnError: (NSError **)error;
- (BOOL)restartPostgresWithOptions:(NSArray *)options error:(NSError **)error;

- (BOOL)isPostgresEnvironmentInitialized;
- (BOOL)initializePostgresEnvironmentAndReturnError: (NSError **)error;

- (BOOL)saveCloudPassword:(NSString *)password forUsername:(NSString *)username;
- (NSString *)cloudPasswordForUsername:(NSString *)username;

- (BOOL)enableFSyncWritethroughAndReturnError: (NSError**)error;
- (BOOL)disableFSyncWritethroughAndReturnError: (NSError**)error;

- (BOOL)deleteClientStageDirectory:(NSString *)directory;

@end
